/*
 * (C) 2015-2016 see Authors.txt
 *
 * This file is part of MPC-BE.
 *
 * MPC-HC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * MPC-HC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "stdafx.h"
#include "FocusThread.h"

IMPLEMENT_DYNCREATE(CFocusThread, CWinThread)

LRESULT CALLBACK FocusWndProc(HWND hwnd, UINT msg, WPARAM wp, LPARAM lp)
{
	if (msg == WM_NCACTIVATE) {
		if (wp) {
			AfxGetMainWnd()->SetForegroundWindow();
		}
		return 0;
	}
	return DefWindowProc(hwnd, msg, wp, lp);
}

CFocusThread::CFocusThread()
	: m_hWnd(NULL)
	, m_hEvtInit(NULL)
{
	WNDCLASS wndclass;

	wndclass.style = CS_HREDRAW | CS_VREDRAW | CS_NOCLOSE;
	wndclass.lpfnWndProc = FocusWndProc;
	wndclass.cbClsExtra = 0;
	wndclass.cbWndExtra = 0;
	wndclass.hInstance = NULL;
	wndclass.hIcon = NULL;
	wndclass.hCursor = NULL;
	wndclass.hbrBackground = NULL;
	wndclass.lpszMenuName = NULL;
	wndclass.lpszClassName = L"D3DFocusClass";

	if (!RegisterClass(&wndclass)) {
		DLog(L"CFocusThread::CFocusThread() : Registering focus window failed");
	}

	m_hEvtInit = CreateEvent(NULL, TRUE, FALSE, NULL);
}

CFocusThread::~CFocusThread()
{
	SAFE_CLOSE_HANDLE(m_hEvtInit);
	UnregisterClass(L"D3DFocusClass", NULL);
}

BOOL CFocusThread::InitInstance()
{
	SetThreadName(DWORD_MAX, "FocusThread");
	m_hWnd = CreateWindow(L"D3DFocusClass", L"D3D Focus Window", WS_OVERLAPPED, 0, 0, 0, 0, NULL, NULL, NULL, NULL);
	SetEvent(m_hEvtInit);
	if (!m_hWnd) {
		DLog(L"CFocusThread::InitInstance() : Creating focus window failed");
		return FALSE;
	}
	return TRUE;
}

int CFocusThread::ExitInstance()
{
	if (m_hWnd) {
		DestroyWindow(m_hWnd);
		m_hWnd = NULL;
	}
	return __super::ExitInstance();
}

HWND CFocusThread::GetFocusWindow()
{
	if (!m_hWnd) {
		WaitForSingleObject(m_hEvtInit, 10000);
	}
	return m_hWnd;
}
